<?php

/**
 * 系统邮件
 */

namespace Framework\Logic;

use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Framework\Model\CommonMailModel;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;

trait CommonMailLogic
{
    use TemplateHelp;

    public function createCommonMail(int $tplId, int $receiveTime = 0): bool
    {
        LogMark::getInstance()->markInfo(
            "[CommonMailLogic] create new system mail",
            array(
                'tplId' => $tplId,
                'receiveTime' => $receiveTime
            )
        );
        //检查邮件模板是否存在
        $configMail = $this->getTitle(TemplateDefine::TYPE_MAIL, $tplId);
        if (is_null($configMail)) {
            LogMark::getInstance()->markWarn(
                GameErrorCode::MAIL_TPL_NOT_EXIST,
                "[CommonMailLogic] create new mail fail,tpl not exist",
                array(
                    'tplId' => $tplId,
                    'receiveTime' => $receiveTime
                )
            );
            return false;
        }
        //如果未指定创建时间 创建时间为当前时间
        if ($receiveTime == 0) {
            $receiveTime = Utils::getServerTimestamp();
        }
        /**
         * @var CommonMailModel $commonMail
         */
        $commonMail = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_MAIL);
        return $commonMail->createCommonMail($tplId, $receiveTime);
    }

    public function getCommonMailByIndex(array $indexArr): array
    {
        /**
         * @var CommonMailModel $commonMail
         */
        $commonMail = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_MAIL);
        return $commonMail->getCommonMailByIndex($indexArr);
    }

    public function delCommonMail(array $indexArr): bool
    {
        /**
         * @var CommonMailModel $commonMail
         */
        $commonMail = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_MAIL);
        return $commonMail->delCommonMail($indexArr);
    }
}
