<?php

/**
 * 系统模块更新索引
 */

namespace Framework\Logic;

use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Framework\Model\CommonDataModel;
use Game\Constant\ModelTypeDefine;

trait CommonDataLogic
{
    /**
     * @param int $model    玩家的model
     * @param int $index
     * @return bool
     */
    public function addCommonData(int $model, int $index): bool
    {
        /**
         * @var CommonDataModel $commonData
         */
        $commonData = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_DATA);
        LogMark::getInstance()->markInfo(
            "[CommonDataLogic] add CommonData",
            array(
                "model" => $model,
                "index" => $index
            )
        );
        return $commonData->addCommonData($model, $index);
    }

    //data (model=>index)
    public function addCommonDataArr(array $data): bool
    {
        /**
         * @var CommonDataModel $commonData
         */
        $commonData = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_DATA);
        LogMark::getInstance()->markInfo(
            "[CommonDataLogic] add CommonData",
            $data
        );
        return $commonData->addCommonDataArr($data);
    }

    public function getCommonData(): array
    {
        /**
         * @var CommonDataModel $commonData
         */
        $commonData = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_DATA);
        $result = array();
        $commonData->getCommonData($result);
        return $result;
    }

    //获取对应model的值
    public function getCommonValueByModel(int $model): ?int
    {
        /**
         * @var CommonDataModel $commonData
         */
        $commonData = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_DATA);
        $result = array();
        $commonData->getCommonData($result);
        return $result[$model] ?? null;
    }
}
