<?php

/**
 * LogMark.php
 * 文件描述
 * Created On 2022/2/10
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Framework\Log;

use Game\Constant\TestParams;
use Library\Common\Singletons;
use Library\SLog;

class LogMark
{
    use Singletons;

    protected int $playerId = 0;

    protected int $lastErrorID = 0;

    protected string $errorLog;

    public function init($logPath): bool
    {
        $bool = SLog::setLogPath($logPath);
        $this->errorLog = SLog::getBasePath() . "/../game.error.log";
        return $bool;
    }

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    public function setLastErrorID(int $errorID)
    {
        $this->lastErrorID = $errorID;
    }

    public function getLastErrorID(): int
    {
        return $this->lastErrorID;
    }

    public function recordIO () {
        ++TestParams::$logNum;
    }

    /**
     * 记录错误信息，影响功能，可以优雅的结束，通知客户端
     */
    public function markError(int $errorId, string $errorInfo, ?array $param = null)
    {
        if (!is_array($param)) {
            $log = $this->playerId . "|" . $errorId . "|" . $errorInfo;
        } else {
            $log = $this->playerId . "|" . $errorId . "|" . $errorInfo . "|" . json_encode($param);
        }
        SLog::error($log);
        $this->markErrorLog($log);
        $this->recordIO();
    }

    /**
     * 记录紧急错误信息，都是框架内使用的，无法正常运行
     * 需要关闭服务器
     */
    public function markCritical(int $errorId, string $errorInfo, ?array $param = null)
    {
        if (!is_array($param)) {
            $log = $this->playerId . "|" . $errorId . "|" . $errorInfo;
        } else {
            $log = $this->playerId . "|" . $errorId . "|" . $errorInfo . "|" . json_encode($param);
        }
        SLog::critical($log);
        $this->markErrorLog($log);
        $this->recordIO();
    }

    /**
     * 游戏正常信息
     */
    public function markInfo($info, ?array $param = null)
    {
        if (!is_array($param)) {
            $log = $this->playerId . "|" . $info;
        } else {
            $log = $this->playerId . "|" . $info . "|" . json_encode($param);
        }
        SLog::info($log);
        $this->recordIO();
    }

    /**
     * 添加调试信息
     */
    public function markDebug($info, ?array $param = null, $level = 0)
    {
        if (!is_array($param)) {
            $log = $this->playerId . "|" . $level . "|" . $info;
        } else {
            $log = $this->playerId . "|" . $level . "|" . $info . "|" . json_encode($param);
        }
        SLog::debug($log);
        $this->recordIO();
    }

    /**
     * 正常情况下不发生的事情，但是不影响整个功能
     */
    public function markWarn($errorId, $errorInfo, ?array $param = null)
    {
        if (!is_array($param)) {
            $log = $this->playerId . "|" . $errorId . "|" . $errorInfo;
        } else {
            $log = $this->playerId . "|" . $errorId . "|" . $errorInfo . "|" . json_encode($param);
        }
        SLog::warning($log);
        $this->recordIO();
    }

    //记录错误日志 方便检查
    private function markErrorLog(string $log)
    {
        $this->recordIO();
        error_log(date("Y-m-d H:i:s") . "\t" . $log . "\r\n", 3, $this->errorLog);
    }
}
