<?php

/**
 * 定义网络消息号与控制器的映射关系
 * Created On 2021/11/1
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Framework\Define;

/**
 * 常量定义消息号对应控制器的映射关系类
 */
interface IControllerDefine
{
    /**
     * 由子类重写，通过消息id获取controller命名空间
     * @param int $id 消息id
     * @return string 对应controller的命名空间
     */
    public function getControllerName(int $id): string;
}
