local exe_ret = {}
exe_ret["error"] = "success"
exe_ret["result"] = ""

--[[
	check condition
--]]
local ret = redis.call('EXISTS' , KEYS[1] )
if ret ~= 0 then
    exe_ret["error"] = "key has exists"
    return cjson.encode(exe_ret)
end
if #ARGV%2 ~= 0 then
	exe_ret["error"] = "param error:not double"
    return cjson.encode(exe_ret)
end
if #ARGV < 4 then
    exe_ret["error"] = "argv number is too litte"
    return cjson.encode(exe_ret)
end

--[[
	redis execute command
--]]
local exe_redis = function ( cmd, key , argvs, argv_index )
	local switch = {
		[0] = function ( cmd, key )
		redis.call( cmd, key )
		end,
		[1] = function ( cmd, key , argvs , index )
		redis.call( cmd, key , argvs[index])
		end,
		[2] = function ( cmd, key , argvs , index )
		redis.call( cmd, key , argvs[index],argvs[index + 1])
		end,
		[3] = function ( cmd, key , argvs , index )
		redis.call( cmd, key , argvs[index],argvs[index + 1] ,argvs[index + 2])
		end,
		[4] = function ( cmd, key , argvs , index )
		redis.call( cmd, key , argvs[index],argvs[index + 1] ,argvs[index + 2] , argvs[index + 3] )
		end,
		[5] = function ( cmd, key , argvs , index )
		redis.call( cmd, key , argvs[index],argvs[index + 1] ,argvs[index + 2] , argvs[index + 3],argvs[index + 4] )
		end,
		[6] = function ( cmd, key , argvs , index )
		redis.call( cmd, key , argvs[index],argvs[index + 1] ,argvs[index + 2] , argvs[index + 3],argvs[index + 4],argvs[index + 5] )
		end,
		[7] = function ( cmd, key , argvs , index )
		redis.call( cmd, key , argvs[index],argvs[index + 1] ,argvs[index + 2] , argvs[index + 3],argvs[index + 4],argvs[index + 5],argvs[index + 6] )
		end,
		[8] = function ( cmd, key , argvs , index )
		redis.call( cmd, key , argvs[index],argvs[index + 1] ,argvs[index + 2] , argvs[index + 3],argvs[index + 4],argvs[index + 5],argvs[index + 6],argvs[index + 7])
		end,
		[9] = function ( cmd, key , argvs , index )
		redis.call( cmd, key , argvs[index],argvs[index + 1] ,argvs[index + 2] , argvs[index + 3],argvs[index + 4],argvs[index + 5],argvs[index + 6],argvs[index + 7],argvs[index + 8])
		end,
		[10] = function ( cmd, key , argvs , index )
		redis.call( cmd, key , argvs[index],argvs[index + 1] ,argvs[index + 2] , argvs[index + 3],argvs[index + 4],argvs[index + 5],argvs[index + 6],argvs[index + 7],argvs[index + 8],  argvs[index + 9])
		end,
	}
	local index = argv_index
	local len = #argvs - index + 1
	if len == 0 then
		switch[0](cmd,key)
		return 1
	end
	while len >=10 do
		switch[10](cmd, key, argvs ,index )
		index = index + 10
		len = len - 10
	end
	if len == 0 then
		return 1
	end
	switch[len](cmd, key , argvs, index)
	return 1
end

--[[
	save hash data
--]]
exe_redis('HMSET', KEYS[1], ARGV, 3)
local title_id = tonumber(ARGV[1])
if title_id == 0 then
    return cjson.encode(exe_ret)
end

--[[
	get data index to add data index
--]]
local index_name = function ( key )
	local index = string.find(key, '}')
	index = string.find(key,'-',index + 2)
	local head  = string.sub(key, 1, index - 1)
	return head
end

local table_index = index_name(KEYS[1])

--[[
	add data index
--]]
redis.call( 'ZADD' , table_index , ARGV[2] , ARGV[1] )

return cjson.encode(exe_ret)