local exe_ret = {}
exe_ret["error"] = 0
exe_ret["result"] = {}

--[[
	redis execute command
--]]
local exe_redis = function(cmd, key, argvs, argv_index)
    local switch = {
        [0] = function(cmd, key)
            redis.call(cmd, key)
        end,
        [1] = function(cmd, key, argvs, index)
            redis.call(cmd, key, argvs[index])
        end,
        [2] = function(cmd, key, argvs, index)
            redis.call(cmd, key, argvs[index], argvs[index + 1])
        end,
        [3] = function(cmd, key, argvs, index)
            redis.call(cmd, key, argvs[index], argvs[index + 1], argvs[index + 2])
        end,
        [4] = function(cmd, key, argvs, index)
            redis.call(cmd, key, argvs[index], argvs[index + 1], argvs[index + 2], argvs[index + 3])
        end,
        [5] = function(cmd, key, argvs, index)
            redis.call(cmd, key, argvs[index], argvs[index + 1], argvs[index + 2], argvs[index + 3], argvs[index + 4])
        end,
        [6] = function(cmd, key, argvs, index)
            redis.call(cmd, key, argvs[index], argvs[index + 1], argvs[index + 2], argvs[index + 3], argvs[index + 4], argvs[index + 5])
        end,
        [7] = function(cmd, key, argvs, index)
            redis.call(cmd, key, argvs[index], argvs[index + 1], argvs[index + 2], argvs[index + 3], argvs[index + 4], argvs[index + 5], argvs[index + 6])
        end,
        [8] = function(cmd, key, argvs, index)
            redis.call(cmd, key, argvs[index], argvs[index + 1], argvs[index + 2], argvs[index + 3], argvs[index + 4], argvs[index + 5], argvs[index + 6], argvs[index + 7])
        end,
        [9] = function(cmd, key, argvs, index)
            redis.call(cmd, key, argvs[index], argvs[index + 1], argvs[index + 2], argvs[index + 3], argvs[index + 4], argvs[index + 5], argvs[index + 6], argvs[index + 7], argvs[index + 8])
        end,
        [10] = function(cmd, key, argvs, index)
            redis.call(cmd, key, argvs[index], argvs[index + 1], argvs[index + 2], argvs[index + 3], argvs[index + 4], argvs[index + 5], argvs[index + 6], argvs[index + 7], argvs[index + 8], argvs[index + 9])
        end,
    }
    local index = argv_index
    local len = #argvs - index + 1
    if len == 0 then
        switch[0](cmd, key)
        return 1
    end
    while len >= 10 do
        switch[10](cmd, key, argvs, index)
        index = index + 10
        len = len - 10
    end
    if len == 0 then
        return 1
    end
    switch[len](cmd, key, argvs, index)
    return 1
end

--[[
	get data index to add data index
--]]
local index_name = function(key)
    local index = string.find(key, '}')
    index = string.find(key, '-', index + 2)
    local head = string.sub(key, 1, index - 1)
    return head
end

--[[ execute single data save ]]
local exe_single = function(param)
    local argvs = cjson.decode(param)
    local exe_ret = {}
    exe_ret["ret"] = 100
    local len = #argvs
    if len < 1 then
        exe_ret["key"] = argvs
        exe_ret["ret"] = 1 --[[ "that number only 1" ]]
        return exe_ret
    end
    local dbKey = argvs[1]
    exe_ret["key"] = dbKey
    if len < 5 then
        exe_ret["ret"] = 2 --[[ "argv number is too shot" ]]
        return exe_ret
    end
    len = len - 3
    local title_id = tonumber(argvs[2])
    local title_score = argvs[3]
    local ret = redis.call('EXISTS', dbKey)
    if ret ~= 0 then
        exe_ret["ret"] = 3 --[["key has exists"]]
        return exe_ret
    end
    if len % 2 ~= 0 then
        exe_ret["ret"] = 4 --[[ "param error:not double"]]
        return exe_ret
    end
    --[[
        save hash data
    --]]
    exe_redis('HMSET', dbKey, argvs, 4)
    if title_id == 0 then
        return exe_ret
    end
    local table_index = index_name(dbKey)
    --[[
        add data index
    --]]
    redis.call('ZADD', table_index, title_score, argvs[2])
    return exe_ret
end

local len = #ARGV
for i = 1, len do
    local ret_j = exe_single(ARGV[i])
    if ret_j["ret"] ~= 100 then
        table.insert(exe_ret["result"], cjson.encode(ret_j))
    end
end

if #exe_ret["result"] > 0 then
    exe_ret["error"] = 1
end
return cjson.encode(exe_ret)