<?php

/**
 * 对战匹配数据操作
 */

namespace Framework\DB\Handler;

use Framework\DB\DBManager;
use Framework\Lib\Utils;
use Game\Constant\DBTableDefine;

trait MatchingDBHandler
{
    public function addQueueByDBKey($table, $dbKey, $term): bool
    {
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_RPUSH,
            $dbKey, $term
        );
        $ret = "";
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    public function searchMultiQueue($table, $dbKey, $start, $end, &$result):bool {
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_LRANGE,
            $dbKey, $start, $end
        );
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $result = json_decode($ret, true);
        return true;
    }

    // bRPop 取数据
    public function selectPopQueue($table, $dbKey, $time, &$result):bool {
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_BR_POP,
            $dbKey, $time
        );
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $result = json_decode($ret, true);
        return true;
    }

    public function delMultiQueue($table, $dbKey, $start, $end):bool {
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_LTRIM,
            $dbKey, $start, $end
        );
        $ret = "";
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

}