<?php

/**
 * tableType类型为非DBTableDefine DB_TYPE_PLAYER类型
 * 修改方法名,与PlayerDBHandle同名的,加Common前缀
 * CommonDBHandler.php
 * 文件描述
 * Created On 2022/1/19
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Framework\DB\Handler;

use Framework\DB\DBManager;
use Framework\Lib\Utils;
use Game\Constant\DBTableDefine;

trait CommonDBHandler
{
    public function createTerm($tableType, $titleId, $key, $val): bool
    {
        $dbKey = Utils::makeDBKey($tableType, $titleId, 0);
        $param = array($dbKey, $key, $val);
        $ret = 0;
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CREATE_TERM,
                $tableType,
                $param,
                $ret
            )
        ) {
            return false;
        }
        if ($ret == 2) {
            return false;
        }
        return true;
    }
    public function searchCommonTerm(&$ret, $tableType, $titleId, $key): bool
    {
        $dbKey = Utils::makeDBKey($tableType, $titleId, 0);
        $param = array(DBTableDefine::DB_LOGIC_CMD_HGET, $dbKey, $key);
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $tableType,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    public function searchTermMultiCommon(&$ret, $tableType, $titleId, array $keyArr): bool
    {
        $dbKey = Utils::makeDBKey($tableType, $titleId, 0);
        $param = array(DBTableDefine::DB_LOGIC_CMD_HMGET, $dbKey, $keyArr);
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $tableType,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $ret = json_decode($ret, true);
        return true;
    }

    public function autoAddCommonTerm(&$ret, $tableType, $titleId, $key, $val): bool
    {
        $dbKey = Utils::makeDBKey($tableType, $titleId, 0);
        $param = array(DBTableDefine::DB_LOGIC_CMD_HINCRBY, $dbKey, $key, $val);
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $tableType,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;

    }

    public function delTermMultiCommon(&$ret, $tableType, $titleId, array $keyArr): bool
    {
        $dbKey = Utils::makeDBKey($tableType, $titleId, 0);
        $param = array(DBTableDefine::DB_LOGIC_CMD_HDel, $dbKey, $keyArr);
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $tableType,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    public function updateCommonTitle($table, $titleId, $data): bool
    {
        $dbKey = Utils::makeDBKey($table, $titleId, 0);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_HMSET,
            $dbKey,
            $data
        );
        $ret = "";
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    // hmset
    public function updateFullServerClusterTitle($table, $titleId, $data): bool
    {
        $dbKey = Utils::makeDBKey($table, 0, $titleId);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_HMSET,
            $dbKey,
            $data
        );
        $ret = "";
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    // del key
    public function deleteCommTitle($table, $titleId): bool
    {
        $dbKey = Utils::makeDBKey($table, 0, $titleId);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_DEL,
            $dbKey
        );
        $ret = "";
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    // guest bind
    public function guestBind($table, $titleId, $data): ?int
    {
        $dbKey = Utils::makeDBKey($table, 1, $titleId);
        $param = array($dbKey);
        foreach ($data as $k => $v) {
            $param[] = $v;
        }
        $param[] = str_replace("1", "5", $dbKey);
        $ret = "";
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_GUEST_BIND,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return $ret;
    }

    // bLPop
    public function searchBLPopQueue($table, $titleID, $time, &$result):bool {
        $dbKey = Utils::makeDBKey($table, 0, $titleID);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_BL_POP,
            $dbKey, $time
        );
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $result = json_decode($ret, true);
        return true;
    }

    // string set saveServiceInfo
    public function saveServiceInfo($table, $serverID, $data):bool {
        $dbKey = Utils::makeDBKey($table, 0, $serverID);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_STR_SET,
            $dbKey, $data);
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    /////////////// ranking start

    public function addRankingInfo($table, $rankType, $seasonID, $mapID, $data): bool {
        $dbKey = Utils::makeRankDbKey($table, $rankType, $seasonID, $mapID);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_HMSET,
            $dbKey,
            $data
        );
        $ret = "";
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    public function getRankingInfo(&$ret, $table, $rankType, $seasonID, $mapID, $keyArr): bool {
        $dbKey = Utils::makeRankDbKey($table, $rankType, $seasonID, $mapID);
        $param = array(DBTableDefine::DB_LOGIC_CMD_HMGET, $dbKey, $keyArr);
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $ret = json_decode($ret, true);
        return true;
    }

    public function setRankKeyExpire($table, $rankType, $seasonID, $mapID, $time, int $pid = 0): bool
    {
        $dbKey = Utils::makeRankDbKey($table, $rankType, $seasonID, $mapID, $pid);
        $param = [
            DBTableDefine::DB_LOGIC_EXPIRE,
            $dbKey, $time
        ];
        $ret = "";
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    public function setRankCacheData($table, $rankType, $seasonID, $mapID, $data): bool {
        $dbKey = Utils::makeRankDbKey($table, $rankType, $seasonID, $mapID);
        $param = [DBTableDefine::DB_LOGIC_CMD_STR_SET, $dbKey, $data];
        $ret = "";
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    public function getRankCacheData($table, $rankType, $seasonID, $mapID, &$result): bool {
        $dbKey = Utils::makeRankDbKey($table, $rankType, $seasonID, $mapID);
        $param = [DBTableDefine::DB_LOGIC_CMD_STR_GET, $dbKey];
        $ret = "";
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $result = $ret;
        return true;
    }

    // del rank cache key
    public function delRankCacheData($table, $rankType, $seasonID, $mapID): bool
    {
        $dbKey = Utils::makeRankDbKey($table, $rankType, $seasonID, $mapID);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_DEL,
            $dbKey
        );
        $ret = "";
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    public function getRankNum($table, $rankType, $seasonID, $mapID, &$result, int $pid = 0): bool
    {
        $dbKey = Utils::makeRankDbKey($table, $rankType, $seasonID, $mapID, $pid);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_ZCARD,
            $dbKey);
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $result = $ret;
        return true;
    }

    public function addRanking($table, $rankType, $seasonID, $mapID, $key, $score, int $pid = 0): bool
    {
        $dbKey = Utils::makeRankDbKey($table, $rankType, $seasonID, $mapID, $pid);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_ZADD,
            $dbKey, $key, $score);
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    public function remRanking($table, $rankType, $seasonID, $mapID, $key): bool
    {
        $dbKey = Utils::makeRankDbKey($table, $rankType, $seasonID, $mapID);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_ZREM,
            $dbKey, $key);
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    // 排行榜数据获取
    public function searchRankData($table, $rankType, $seasonID, $start, $stop
                                    , $mapID, &$result, int $pid = 0): bool
    {
        $dbKey = Utils::makeRankDbKey($table, $rankType, $seasonID, $mapID, $pid);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_ZRANGE,
            $dbKey, $start, $stop , true
        );
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $result = json_decode($ret, true);
        return true;
    }

    // 排行榜倒叙数据获取
    public function searchRevRankData($table, $rankType, $seasonID, $start, $stop
        , $mapID, &$result, int $pid = 0): bool
    {
        $dbKey = Utils::makeRankDbKey($table, $rankType, $seasonID, $mapID, $pid);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_Z_REV_RANGE,
            $dbKey, $start, $stop , true
        );
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $result = json_decode($ret, true);
        return true;
    }

    // rank zScore
    public function searchRankLikeScoreByKey($table, $rankType, $seasonID, $mapID, $key, &$ret, $pid): bool
    {
        $dbKey = Utils::makeRankDbKey($table, $rankType, $seasonID, $mapID, $pid);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_ZSCORE,
            $dbKey, $key
        );
        $ret = '';
        return false != DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            );
    }

    public function searchRankKeyExists($table, $rankType, $seasonID, $mapID, &$ret, $pid): bool
    {
        $dbKey = Utils::makeRankDbKey($table, $rankType, $seasonID, $mapID, $pid);
        $param = array(
            DBTableDefine::DB_LOGIC_EXISTS,
            $dbKey
        );
        $ret = '';
        return false != DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            );
    }

    public function searchRankDataByScoreWithScores($table, $rankType, $seasonID, $mapID, $start, $stop,
                    &$result, $pid = 0): bool
    {
        $dbKey = Utils::makeRankDbKey($table, $rankType, $seasonID, $mapID, $pid);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_ZRANGE_BY_SCORE,
            $dbKey, $start, $stop , true
        );
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $result = json_decode($ret, true);
        return true;
    }

    /////////////// ranking end

    // ins queue
    public function insQueueRPushCommon($table, $sendServer, $data): bool
    {
        $dbKey = Utils::makeDBKey($table, 0, $sendServer);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_RPUSH,
            $dbKey, $data
        );
        $ret = "";
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    // set expire
    public function setKeyExpire($table, $key, $time): bool
    {
        $param = [
            DBTableDefine::DB_LOGIC_EXPIRE,
            $key, $time
        ];
        $ret = "";
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    // HGetAll
    public function searchFullServerClusterTitle($table, $titleId, &$result): bool
    {
        $dbKey = Utils::makeDBKey($table, 0, $titleId);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_HGETALL,
            $dbKey
        );
        $ret = "";
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $result = json_decode($ret, true);
        return true;
    }

    // hDel
    public function hDelCommTitle($table, $key): bool
    {
        $dbKey = Utils::makeDBKey($table, 0, 0);
        $param = array(DBTableDefine::DB_LOGIC_CMD_HDel, $dbKey, [$key]);
        return false != DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            );
    }

    // ZScore
    public function searchCommRankScoreByKey($table, $titleId,$key, &$ret): bool
    {
        $dbKey = Utils::makeDBKey($table, 0, $titleId);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_ZSCORE,
            $dbKey, $key
        );
        $ret = '';
        return false != DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            );
    }

    // ZSet
    public function addFullServerSingleRank($table, $titleId, $key, $score): bool
    {
        $dbKey = Utils::makeDBKey($table, 0, $titleId);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_ZADD,
            $dbKey, $key, $score);
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    public function searchCommonTitle($table, $titleId, &$result): bool
    {
        $dbKey = Utils::makeDBKey($table, $titleId, 0);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_HGETALL,
            $dbKey
        );
        $ret = "";
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $result = json_decode($ret, true);
        return true;
    }

    public function addCommonRank($table, $titleId, $key, $score): bool
    {
        $dbKey = Utils::makeDBKey($table, $titleId, 0);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_ZADD,
            $dbKey, $key, $score);
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    public function delCommonRank($table, $titleId, $key): bool
    {
        $dbKey = Utils::makeDBKey($table, $titleId, 0);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_ZREM,
            $dbKey, $key);
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    public function setMemberFullServerSingle($table, $titleId, $key): bool
    {
        $dbKey = Utils::makeDBKey($table, 0,$titleId);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_SET,
            $dbKey, $key);
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    // SRem
    public function delSetMember($table, $titleId, $key): bool
    {
        $dbKey = Utils::makeDBKey($table, 0, $titleId);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_SREM,
            $dbKey, $key);
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    public function delZRemByScore($table, $titleId,$start, $stop): bool
    {
        $dbKey = Utils::makeDBKey($table, 0, $titleId);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_Z_REM_RANGE_BY_SCORE,
            $dbKey, $stop,  $start);
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    public function searchCommonRank($table, $titleId, $start, $stop, &$result): bool
    {
        $dbKey = Utils::makeDBKey($table, $titleId, 0);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_ZRANGE_BY_SCORE,
            $dbKey, $start, $stop , true
        );
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $result = json_decode($ret, true);
        return true;
    }

    public function searchRankScoreByKeyCommon($table, $titleId,$key, &$ret): bool
    {
        $dbKey = Utils::makeDBKey($table, $titleId, 0);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_ZSCORE,
            $dbKey, $key
        );
        $ret = '';
        return false != DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            );
    }

    public function searchRevRankByIndexCommon($table, $playerId, $start, $stop, &$result): bool
    {
        $dbKey = Utils::makeDBKey($table, $playerId, 0);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_Z_REV_RANGE_BY_SCORE,
            $dbKey, $stop,  $start, true );
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $result = json_decode($ret, true);
        return true;
    }

    //随机搜索集合列表
    public function searchSetRandomList($table, $playerId, $count, &$ret): bool
    {
        $dbKey = Utils::makeDBKey($table, $playerId, 0);
        $param = array(DBTableDefine::DB_LOGIC_CMD_SRANDMEMBER, $dbKey, $count);
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $ret = json_decode($ret, true);
        return true;
    }

    //查询集合的成员数量
    public function getSetLen($table, $playerId, &$ret): bool
    {
        $dbKey = Utils::makeDBKey($table, $playerId, 0);
        $param = array(DBTableDefine::DB_LOGIC_CMD_SCARD, $dbKey);
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        return true;
    }

    //查询集合的所有成员
    public function searchSetMember($table, $playerId, &$ret): bool
    {
        $dbKey = Utils::makeDBKey($table, $playerId, 0);
        $param = array(DBTableDefine::DB_LOGIC_CMD_SMEMBERS, $dbKey);
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $ret = json_decode($ret, true);
        return true;
    }

    public function searchRankByRevRange(&$result, $table, $playerId, $start, $stop,  $title = 0): bool
    {
        $dbKey = Utils::makeDBKey($table, $playerId, $title);
        $param = array(
            DBTableDefine::DB_LOGIC_CMD_Z_REV_RANGE,
            $dbKey, $start, $stop , true );
        $ret = '';
        if (
            false == DBManager::getInstance()->executeRedis(
                DBTableDefine::DB_LOGIC_COMMON_CMD,
                $table,
                $param,
                $ret
            )
        ) {
            return false;
        }
        $result = json_decode($ret, true);
        return true;
    }

    //替换昵称
    public function replaceNicknameDB($table, $titleId, $data): bool
    {
        $dbKey = Utils::makeDBKey($table, $titleId, 0);
        $param = array($dbKey);
        foreach ($data as $k => $v) {
            $param[] = $v;
        }
        $ret = "";
        return DBManager::getInstance()->executeRedis(
            DBTableDefine::DB_LOGIC_REPLACE_NICKNAME,
            $table,
            $param,
            $ret
            );
    }
}
