<?php


namespace Framework\DB\DBLogic;

use Game\Constant\DBTableDefine;
use Game\Constant\GameDBLogicDefine;

class PlayerSearchTable extends DBLogicRedisScript
{
    public function __construct()
    {
        $this->keyNum = 1;
        $this->sha = GameDBLogicDefine::LOGIC_LIST[DBTableDefine::DB_LOGIC_PLAYER_SEARCH_TABLE];
    }

    public function dealResult(&$des): bool
    {
        $des = array();
        $title = explode("^", $this->result['result']);
        foreach ($title as $val) {
            $tmparr = explode("&", $val);
            if (count($tmparr) != 2) {
                break;
            }
            $ktmp = explode("-", $tmparr [0]);
            if (count($ktmp) != 5) {
                break;
            }
            $vtmp = explode("~", $tmparr [1]);
            $val = array();
            $i = 1;
            $in = 0;
            foreach ($vtmp as $k) {
                if ($i % 2 == 0) {
                    $val [$in] = $k;
                } else {
                    $in = $k;
                }
                $i++;
            }
            ksort($val, SORT_STRING);
            $des [$ktmp [4]] = $val;
        }
        return true;
    }
}