<?php

/**
 * 配置类，由游戏配置框架的相关参数
 * Created On 2021/11/1
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Framework\Common;

use Framework\Network\ICheckRequest;
use Framework\Network\ReceiveMessage;
use Library\Common\Singletons;
use Framework\DB\DBContainer;
use Framework\Define\IControllerDefine;
use Framework\Define\DBDefine;
use Framework\DB\DBManager;
use Framework\Define\IModelDefine;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;

/**
 * 框架各个模块初始化的相关参数
 */
class ConfigManager
{
    use Singletons;

    /**
     * @var IControllerDefine $packetDefine 消息对应controller配置
     */
    private IControllerDefine $packetDefine;

    private IModelDefine $modelDefine;

    private DBDefine $redisConfig;

    private ICheckRequest $check;

    /**
     * 各个模块开始加载配置信息
     * @return bool
     */
    public function loadConfig(): bool
    {
        ReceiveMessage::getInstance()->init($this->packetDefine, $this->check);
        ModelManager::getInstance()->init($this->modelDefine);
        DBContainer::getInstance()->init($this->redisConfig);
        DBManager::getInstance()->init($this->redisConfig);
        SendMessage::getInstance()->init();
        return true;
    }

    /**
     * 断开连接之前的调用，清理配置
     */
    public function closeConnect()
    {
    }

    /**
     * 设置游戏的消息配置
     * @param IControllerDefine $obj 游戏中消息对应controller配置
     * @api
     */
    public function setPacketDefine(IControllerDefine $obj)
    {
        $this->packetDefine = $obj;
    }

    public function setModelDefine(IModelDefine $define)
    {
        $this->modelDefine = $define;
    }

    public function setRedisConfig(DBDefine $redisConfig)
    {
        $this->redisConfig = $redisConfig;
    }

    public function setCheckRequest(ICheckRequest $c )
    {
        $this->check = $c;
    }
}
